/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.Vector;
import main.JapDict;
import main.JapList;
import main.JapQuery;
import main.JapRevQuery;

class WordSearchEngine {
    private int CurrentResult = -1;
    private String LastExpression = "";
    public int PageSize = 10;
    private JapQuery JPQuery = new JapQuery();
    public JapRevQuery JPRevQuery = new JapRevQuery();
    private JapDict JPDict = new JapDict();
    private Vector CachedResults = new Vector();
    private Vector CachedStrings = new Vector();
    private boolean EndOfSearch = true;

    private int FindFirst(String word, int wordLen) {
        int found = 0;
        this.CurrentResult = -1;
        this.EndOfSearch = false;
        this.CachedStrings.removeAllElements();
        this.CachedStrings.trimToSize();
        this.CachedResults.removeAllElements();
        this.CachedResults.trimToSize();
        this.LastExpression = word;
        boolean jap = this.LastExpression.charAt(0) >= '\u3000';
        int res = this.LastExpression.charAt(0) >= '\u3000' ? this.JPQuery.FindFirst(this.LastExpression, wordLen) : this.JPRevQuery.FindFirst(this.LastExpression);
        if (res > 0) {
            this.CurrentResult = 0;
            this.CachedResults.addElement(new Integer(res));
            ++found;
        } else {
            this.EndOfSearch = true;
        }
        if (this.PageSize > 1) {
            int remain = this.PageSize - 1;
            found += this.FindNext(remain);
        }
        return found;
    }

    private int FindNext(int numWords) {
        int found = 0;
        boolean jap = this.LastExpression.charAt(0) >= '\u3000';
        for (int i = 0; i < numWords; ++i) {
            int res = jap ? this.JPQuery.FindNext() : this.JPRevQuery.FindNext();
            if (res > 0) {
                this.CachedResults.addElement(new Integer(res));
                ++found;
                continue;
            }
            this.EndOfSearch = true;
            break;
        }
        return found;
    }

    private void feed(int until) {
        for (int i = this.CachedStrings.size(); i < until + 1; ++i) {
            Integer didx = (Integer)this.CachedResults.elementAt(i);
            String s = this.JPDict.GetEntry(didx);
            this.CachedStrings.addElement(s);
        }
    }

    private String getResult(int index) {
        if (index >= 0 && index < this.CachedResults.size()) {
            if (index >= this.CachedStrings.size()) {
                this.feed(index);
            }
            if (index >= this.CachedStrings.size()) {
                return "";
            }
            return (String)this.CachedStrings.elementAt(index);
        }
        return "";
    }

    public int initSearch(String word, int wordLen) {
        return this.FindFirst(word, wordLen);
    }

    public String getCurrentResult() {
        return this.getResult(this.CurrentResult);
    }

    public String getNextResult() {
        int found;
        if (this.CurrentResult + 1 >= this.CachedResults.size() && !this.EndOfSearch && (found = this.FindNext(this.PageSize)) == 0) {
            return "";
        }
        if (this.CurrentResult >= this.CachedResults.size()) {
            return "";
        }
        ++this.CurrentResult;
        return this.getCurrentResult();
    }

    public String getPrevResult() {
        --this.CurrentResult;
        if (this.CurrentResult < -1) {
            this.CurrentResult = -1;
        }
        return this.getCurrentResult();
    }

    public boolean allResultsAreCached() {
        return this.EndOfSearch;
    }

    public int getCurrentResultPosition() {
        return this.CurrentResult;
    }

    public int getCachedNumber() {
        return this.CachedResults.size();
    }

    public String getLastExpression() {
        return this.LastExpression;
    }

    public void goTo(int index) {
        if (index >= 0 && index < this.CachedResults.size()) {
            this.CurrentResult = index;
        }
    }

    public void goToLastCached() {
        this.goTo(this.getCachedNumber() - 1);
    }

    public void linkWithList(JapList list) {
        list.setLinkedItems(this.CachedStrings);
    }

    public void feedCached() {
        this.feed(this.CachedResults.size() - 1);
    }
}

