/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Random;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class WordList {
    int CurrentItemIndex = -1;
    long LastUsedSeed = 0L;
    String LastFileName = "";
    Vector Items = new Vector();
    Vector ItemsB = new Vector();
    Vector IdxList = new Vector();
    public boolean ShowReverse = false;
    public boolean FullText = false;
    public boolean TwoSided = false;

    public String CurrentItem() {
        if (this.IdxList.size() < 1) {
            return "";
        }
        WordItem idx = (WordItem)this.IdxList.elementAt(this.CurrentItemIndex);
        if (this.ShowReverse && idx.Index < this.ItemsB.size()) {
            return (String)this.ItemsB.elementAt(idx.Index);
        }
        return (String)this.Items.elementAt(idx.Index);
    }

    public String PrevItem() {
        if (this.IdxList.size() < 1) {
            return "";
        }
        --this.CurrentItemIndex;
        if (this.CurrentItemIndex < 0) {
            this.CurrentItemIndex = this.IdxList.size() - 1;
        }
        return this.CurrentItem();
    }

    public String NextItem() {
        if (this.IdxList.size() < 1) {
            return "";
        }
        this.CurrentItemIndex = (this.CurrentItemIndex + 1) % this.IdxList.size();
        return this.CurrentItem();
    }

    private void resetIndex() {
        this.IdxList.removeAllElements();
        for (int i = 0; i < this.Items.size(); ++i) {
            this.IdxList.addElement(new WordItem(i));
        }
    }

    public void randomizeList(long withThisSeed) {
        Random random = new Random();
        this.LastUsedSeed = withThisSeed;
        if (this.LastUsedSeed == 0L) {
            this.LastUsedSeed = random.nextInt();
        }
        random.setSeed(this.LastUsedSeed);
        this.resetIndex();
        int itemCount = this.IdxList.size();
        for (int i = 0; i < this.IdxList.size(); ++i) {
            int rand = Math.abs(random.nextInt()) % itemCount;
            WordItem a = (WordItem)this.IdxList.elementAt(i);
            WordItem b = (WordItem)this.IdxList.elementAt(rand);
            int t = b.Index;
            b.Index = a.Index;
            a.Index = t;
        }
    }

    private void AddItem(String s, boolean sideB) {
        if (sideB && this.TwoSided) {
            this.ItemsB.addElement(s);
        } else {
            this.Items.addElement(s);
        }
    }

    public boolean Load(String fname, int currentIndex, long randomSeed) {
        boolean sideB = false;
        try {
            int chr;
            this.ShowReverse = false;
            this.CurrentItemIndex = -1;
            this.LastFileName = "";
            this.Items.removeAllElements();
            this.ItemsB.removeAllElements();
            this.resetIndex();
            FileConnection fc = (FileConnection)Connector.open((String)("file://localhost/" + fname));
            InputStream is = fc.openInputStream();
            InputStreamReader isr = new InputStreamReader(is, "UTF-8");
            isr.read();
            StringBuffer sb = new StringBuffer();
            while ((chr = isr.read()) != -1) {
                if (chr != 10 | this.FullText) {
                    if (chr == 13) continue;
                    if (this.TwoSided && chr == 124) {
                        chr = 10;
                    }
                    sb.append((char)chr);
                    continue;
                }
                String s = sb.toString();
                if (s.length() <= 0) continue;
                this.AddItem(s, sideB);
                sb.setLength(0);
                sideB = !sideB;
            }
            if (sb.length() > 0) {
                this.AddItem(sb.toString(), sideB);
            }
            isr.close();
            is.close();
            fc.close();
            if (randomSeed != 0L) {
                this.randomizeList(randomSeed);
            } else {
                this.resetIndex();
            }
            this.CurrentItemIndex = currentIndex;
            if (this.CurrentItemIndex < 0) {
                this.CurrentItemIndex = 0;
            }
            if (this.CurrentItemIndex >= this.Items.size()) {
                this.CurrentItemIndex = this.Items.size() - 1;
            }
            this.LastFileName = fname;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private class WordItem {
        int Index;

        public WordItem(int index) {
            this.Index = index;
        }
    }
}

