/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MangaBook {
    private MangaBookEntry[] Entries = null;
    private FileConnection FConnection = null;
    private InputStream IStream = null;
    private int StreamPos = 0;
    private Vector PicFN = null;
    public Vector Regions = null;
    public int CurrentPicNumber = -1;
    public int CurrentRegNumber = -1;
    public Image Pic = null;
    private boolean Drawing = false;
    private boolean HQDisabled = false;
    private long HQDisableInitTime = 0L;
    private boolean NeedsRepaint = true;
    public boolean KeepAspect = true;
    public static final int DRAW_MODE_LQ = 0;
    public static final int DRAW_MODE_BW = 1;
    public static final int DRAW_MODE_HQ = 2;
    public int DrawMode = 2;
    private int LastDrawMode;
    private int ScreenWidth = 0;
    private int ScreenHeight = 0;
    private int XPos;
    private int YPos;
    private int XWidth;
    private int YHeight;
    private float ScaleFact = 1.0f;
    public String Filename = "";

    public MangaBook(int screenWidth, int screenHeight) {
        this.ScreenWidth = screenWidth;
        this.ScreenHeight = screenHeight;
    }

    private int readInt() {
        try {
            int[] b = new int[4];
            b[0] = this.IStream.read();
            ++this.StreamPos;
            b[1] = this.IStream.read();
            ++this.StreamPos;
            b[2] = this.IStream.read();
            ++this.StreamPos;
            b[3] = this.IStream.read();
            ++this.StreamPos;
            return b[3] << 24 | b[2] << 16 | b[1] << 8 | b[0];
        }
        catch (Exception e) {
            return 0;
        }
    }

    private String readStr() {
        try {
            int chr;
            StringBuffer sb = new StringBuffer();
            while ((chr = this.IStream.read()) != -1) {
                ++this.StreamPos;
                if (chr == 0) {
                    return sb.toString();
                }
                sb.append((char)chr);
            }
            return new String("");
        }
        catch (Exception e) {
            return new String("");
        }
    }

    public boolean extMatch(String fn, String[] ext) {
        boolean valid = false;
        if (fn.length() > 3) {
            String fext = fn.substring(fn.length() - 3);
            for (int cnt = 0; cnt < ext.length; ++cnt) {
                if (!fext.equalsIgnoreCase(ext[cnt])) continue;
                valid = true;
                break;
            }
        }
        return valid;
    }

    private boolean readMangaBookContent() {
        try {
            String[] ext = new String[]{"jpg", "png", "gif", "bmp"};
            int id = this.readInt();
            int ver = this.readInt();
            int nfiles = this.readInt();
            int offset = 12;
            this.Entries = null;
            this.Entries = new MangaBookEntry[nfiles];
            this.PicFN = null;
            this.PicFN = new Vector();
            if (id == 4673101 && ver == 1 && nfiles > 0) {
                int i;
                for (i = 0; i < nfiles; ++i) {
                    int fsize = this.readInt();
                    offset += 4;
                    String fname = this.readStr();
                    offset = offset + fname.length() + 1;
                    this.Entries[i] = new MangaBookEntry();
                    this.Entries[i].fileName = fname;
                    this.Entries[i].fileSize = fsize;
                    this.Entries[i].fileOffset = 0;
                    if (!this.extMatch(fname, ext)) continue;
                    this.PicFN.addElement(new String(fname));
                }
                for (i = 0; i < nfiles; ++i) {
                    this.Entries[i].fileOffset = offset;
                    offset += this.Entries[i].fileSize;
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean open(String fn) {
        try {
            this.Filename = "";
            if (this.IStream != null) {
                this.IStream.close();
                this.IStream = null;
            }
            if (this.FConnection != null) {
                this.FConnection.close();
                this.FConnection = null;
            }
            this.FConnection = (FileConnection)Connector.open((String)("file://localhost/" + fn));
            this.IStream = this.FConnection.openDataInputStream();
            this.StreamPos = 0;
            this.CurrentPicNumber = -1;
            this.CurrentRegNumber = -1;
            if (!this.readMangaBookContent()) {
                return false;
            }
            this.Filename = fn;
            return true;
        }
        catch (Exception _e) {
            this.Filename = "";
            return false;
        }
    }

    private int seekFile(String fn) {
        for (int i = 0; i < this.Entries.length; ++i) {
            if (!fn.equalsIgnoreCase(this.Entries[i].fileName)) continue;
            try {
                int offset = this.Entries[i].fileOffset;
                if (this.StreamPos != offset) {
                    this.IStream.close();
                    this.IStream = this.FConnection.openDataInputStream();
                    this.StreamPos = (int)this.IStream.skip(offset);
                }
                return i;
            }
            catch (Exception _e) {
                return -2;
            }
        }
        return -1;
    }

    public boolean loadRegionsFromIS() {
        StringBuffer sb = new StringBuffer();
        try {
            int chr;
            while ((chr = this.IStream.read()) != -1) {
                ++this.StreamPos;
                if (chr == 10) {
                    String line = sb.toString();
                    sb.setLength(0);
                    int x0 = Integer.parseInt(line.substring(0, 4));
                    int y0 = Integer.parseInt(line.substring(5, 9));
                    int x1 = Integer.parseInt(line.substring(10, 14));
                    int y1 = Integer.parseInt(line.substring(15, 19));
                    this.Regions.addElement(new ComicRegion(x0, y0, x1, y1));
                    continue;
                }
                if (chr == 13) continue;
                sb.append((char)chr);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean loadRegions(String fn) {
        this.Regions = null;
        this.Regions = new Vector();
        this.CurrentRegNumber = -1;
        try {
            int seek = this.seekFile(fn);
            if (seek >= 0) {
                return this.loadRegionsFromIS();
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean loadImage(String fn) {
        try {
            this.Pic = null;
            int seek = this.seekFile(fn);
            if (seek >= 0) {
                int readed = 0;
                int remain = this.Entries[seek].fileSize;
                byte[] picData = new byte[remain];
                int read = 1;
                while (remain > 0 & read > 0) {
                    read = this.IStream.read(picData, readed, remain);
                    if (read <= 0) continue;
                    this.StreamPos += read;
                    readed += read;
                    remain -= read;
                }
                if (remain == 0) {
                    Thread thisThread = Thread.currentThread();
                    while (this.Drawing) {
                        Thread.sleep(1L);
                    }
                    this.Pic = null;
                    this.Pic = Image.createImage((byte[])picData, (int)0, (int)picData.length);
                    picData = null;
                    return this.Pic != null;
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void loadCurrentPic() {
        String fn = (String)this.PicFN.elementAt(this.CurrentPicNumber);
        this.loadImage(fn);
        if (fn.length() > 3) {
            fn = fn.substring(0, fn.length() - 3);
            this.loadRegions(fn + "rgn");
            this.nextRegion();
        } else {
            this.picModif();
        }
    }

    private void loadCurrentRegion() {
        ComicRegion reg = (ComicRegion)this.Regions.elementAt(this.CurrentRegNumber);
        this.XPos = -reg.x0;
        this.YPos = -reg.y0;
        this.XWidth = reg.x1 - reg.x0 + 1;
        this.YHeight = reg.y1 - reg.y0 + 1;
        float h = this.YHeight;
        float sh = this.ScreenHeight;
        this.ScaleFact = h / sh;
        this.picModif();
    }

    public void nextRegion() {
        if (this.Regions.size() < 1) {
            return;
        }
        this.CurrentRegNumber = (this.CurrentRegNumber + 1) % this.Regions.size();
        this.loadCurrentRegion();
    }

    public void prevRegion() {
        if (this.Regions.size() < 1) {
            return;
        }
        --this.CurrentRegNumber;
        if (this.CurrentRegNumber < 0) {
            this.CurrentRegNumber = 0;
        }
        this.loadCurrentRegion();
    }

    public void nextPic() {
        this.CurrentPicNumber = (this.CurrentPicNumber + 1) % this.PicFN.size();
        this.loadCurrentPic();
    }

    public void seekPic(int index, int region) {
        if (index >= 0 & index < this.PicFN.size()) {
            this.CurrentPicNumber = index;
            this.loadCurrentPic();
            if (region >= 0 & region < this.Regions.size()) {
                this.CurrentRegNumber = region;
                this.loadCurrentRegion();
            }
        }
    }

    public void drawScaledImage(Graphics dstGfx, int dstX, int dstY, Image srcPic, int dstW, int dstH, int x0, int y0, int x1, int y1) {
        int srcW = srcPic.getWidth();
        int srcH = srcPic.getHeight();
        int regW = x1 - x0 + 1;
        int regH = y1 - y0 + 1;
        int lastScanline = -1;
        int[] scanline = new int[srcW];
        int[] displayp = new int[dstW * dstH];
        for (int y = 0; y < dstH; ++y) {
            int doffx = y * dstW;
            int yy = y0 + y * regH / dstH;
            if (yy < 0 || yy >= srcH) continue;
            if (lastScanline != yy) {
                srcPic.getRGB(scanline, 0, srcW, 0, yy, srcW, 1);
            }
            lastScanline = yy;
            for (int x = 0; x < dstW; ++x) {
                int xx = x0 + x * regW / dstW;
                if (xx < 0 || xx >= srcW) continue;
                displayp[doffx + x] = scanline[xx];
            }
        }
        dstGfx.drawRGB(displayp, 0, dstW, dstX, dstY, dstW, dstH, false);
    }

    private int blendColors(int a, int b, float ratio) {
        int b0 = a & 0xFF;
        int b1 = b & 0xFF;
        int bf = b0 + (int)((float)(b1 - b0) * ratio);
        int g0 = a >> 8 & 0xFF;
        int g1 = b >> 8 & 0xFF;
        int gf = g0 + (int)((float)(g1 - g0) * ratio);
        int r0 = a >> 16 & 0xFF;
        int r1 = b >> 16 & 0xFF;
        int rf = r0 + (int)((float)(r1 - r0) * ratio);
        return 0xFF000000 | rf << 16 | gf << 8 | bf;
    }

    public void drawScaledImageBF(Graphics dstGfx, int dstX, int dstY, Image srcPic, int dstW, int dstH, int x0, int y0, int x1, int y1) {
        int srcW = srcPic.getWidth();
        int srcH = srcPic.getHeight();
        int regW = x1 - x0 + 1;
        int regH = y1 - y0 + 1;
        int lastScanline = -1;
        int[] scanlineA = new int[srcW];
        int[] scanlineB = new int[srcW];
        int[] displayp = new int[dstW * dstH];
        for (int y = 0; y < dstH; ++y) {
            int doffx = y * dstW;
            float yyf = (float)y0 + (float)(y * regH) / (float)dstH;
            int yy = (int)Math.floor(yyf);
            float yyr0 = yyf - (float)yy;
            if (yy < 0 || yy >= srcH - 1) continue;
            if (lastScanline != yy) {
                srcPic.getRGB(scanlineA, 0, srcW, 0, yy, srcW, 1);
                srcPic.getRGB(scanlineB, 0, srcW, 0, yy + 1, srcW, 1);
            }
            lastScanline = yy;
            for (int x = 0; x < dstW; ++x) {
                float xxf = (float)x0 + (float)(x * regW) / (float)dstW;
                int xx = (int)Math.floor(xxf);
                float xxr0 = xxf - (float)xx;
                if (xx < 0 || xx >= srcW - 1) continue;
                int fcolorA = this.blendColors(scanlineA[xx], scanlineA[xx + 1], xxr0);
                int fcolorB = this.blendColors(scanlineB[xx], scanlineB[xx + 1], xxr0);
                displayp[doffx + x] = this.blendColors(fcolorA, fcolorB, yyr0);
            }
        }
        dstGfx.drawRGB(displayp, 0, dstW, dstX, dstY, dstW, dstH, false);
    }

    private int blendGrays(int a, int b, float ratio) {
        int b0 = a & 0xFF;
        int b1 = b & 0xFF;
        int bf = b0 + (int)((float)(b1 - b0) * ratio);
        return 0xFF000000 | bf << 16 | bf << 8 | bf;
    }

    public void drawScaledImageBWBF(Graphics dstGfx, int dstX, int dstY, Image srcPic, int dstW, int dstH, int x0, int y0, int x1, int y1) {
        int srcW = srcPic.getWidth();
        int srcH = srcPic.getHeight();
        int regW = x1 - x0 + 1;
        int regH = y1 - y0 + 1;
        int lastScanline = -1;
        int[] scanlineA = new int[srcW];
        int[] scanlineB = new int[srcW];
        int[] displayp = new int[dstW * dstH];
        for (int y = 0; y < dstH; ++y) {
            int doffx = y * dstW;
            float yyf = (float)y0 + (float)(y * regH) / (float)dstH;
            int yy = (int)Math.floor(yyf);
            float yyr0 = yyf - (float)yy;
            if (yy < 0 || yy >= srcH - 1) continue;
            if (lastScanline != yy) {
                srcPic.getRGB(scanlineA, 0, srcW, 0, yy, srcW, 1);
                srcPic.getRGB(scanlineB, 0, srcW, 0, yy + 1, srcW, 1);
            }
            lastScanline = yy;
            for (int x = 0; x < dstW; ++x) {
                float xxf = (float)x0 + (float)(x * regW) / (float)dstW;
                int xx = (int)Math.floor(xxf);
                float xxr0 = xxf - (float)xx;
                if (xx < 0 || xx >= srcW - 1) continue;
                int fcolorA = this.blendGrays(scanlineA[xx], scanlineA[xx + 1], xxr0);
                int fcolorB = this.blendGrays(scanlineB[xx], scanlineB[xx + 1], xxr0);
                displayp[doffx + x] = this.blendGrays(fcolorA, fcolorB, yyr0);
            }
        }
        dstGfx.drawRGB(displayp, 0, dstW, dstX, dstY, dstW, dstH, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics g) {
        this.Drawing = true;
        try {
            if (this.Pic == null) {
                return;
            }
            int mode = this.DrawMode;
            long time = System.currentTimeMillis();
            if (time != 0L & time - this.HQDisableInitTime < 1000L) {
                mode = 0;
            }
            if (mode != this.LastDrawMode) {
                this.NeedsRepaint = true;
            }
            this.LastDrawMode = mode;
            if (!this.NeedsRepaint) {
                return;
            }
            int x0 = -this.XPos;
            int y0 = -this.YPos;
            int x1 = x0 + this.XWidth - 1;
            int y1 = y0 + this.YHeight - 1;
            if (this.KeepAspect) {
                x1 = x0 + (int)((float)(this.ScreenWidth - 1) * this.ScaleFact);
                y1 = y0 + (int)((float)(this.ScreenHeight - 1) * this.ScaleFact);
            }
            g.setColor(0, 0, 128);
            g.fillRect(0, 0, this.ScreenWidth, this.ScreenHeight);
            if (x1 - x0 + 1 == this.ScreenWidth && y1 - y0 + 1 == this.ScreenHeight) {
                g.drawImage(this.Pic, this.XPos, this.YPos, 20);
            } else {
                switch (mode) {
                    case 0: {
                        this.drawScaledImage(g, 0, 0, this.Pic, this.ScreenWidth, this.ScreenHeight, x0, y0, x1, y1);
                        break;
                    }
                    case 1: {
                        this.drawScaledImageBWBF(g, 0, 0, this.Pic, this.ScreenWidth, this.ScreenHeight, x0, y0, x1, y1);
                        break;
                    }
                    case 2: {
                        this.drawScaledImageBF(g, 0, 0, this.Pic, this.ScreenWidth, this.ScreenHeight, x0, y0, x1, y1);
                    }
                }
            }
            this.NeedsRepaint = false;
        }
        finally {
            this.Drawing = false;
        }
    }

    private void picModif() {
        this.HQDisableInitTime = System.currentTimeMillis();
        this.NeedsRepaint = true;
    }

    public void move(int x, int y) {
        this.picModif();
        this.XPos += x;
        this.YPos += y;
    }

    public void moveAbs(int x, int y) {
        this.picModif();
        this.XPos = x;
        this.YPos = y;
    }

    private void fixScaleF() {
        if (this.ScaleFact < 0.1f) {
            this.ScaleFact = 0.1f;
        }
        if (this.ScaleFact > 8.0f) {
            this.ScaleFact = 8.0f;
        }
    }

    public void scale(float f) {
        this.picModif();
        this.ScaleFact += f;
        this.fixScaleF();
    }

    public void scaleAbs(float f) {
        this.picModif();
        this.ScaleFact = f;
        this.fixScaleF();
    }

    public void invokePaint() {
        this.picModif();
    }

    class ComicRegion {
        public int x0;
        public int y0;
        public int x1;
        public int y1;

        public ComicRegion(int _x0, int _y0, int _x1, int _y1) {
            this.x0 = _x0;
            this.y0 = _y0;
            this.x1 = _x1;
            this.y1 = _y1;
        }
    }

    class MangaBookEntry {
        public String fileName;
        public int fileSize;
        public int fileOffset;

        MangaBookEntry() {
        }
    }
}

