/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class KanQuery {
    public String LastEntryFound = "";
    public String LastFound_Kanji = "";
    public String LastFound_PicID = "";
    public String LastFound_Freq = "";
    public String LastFound_Grade = "";
    public String LastFound_Strokes = "";
    public String LastFound_On = "";
    public String LastFound_Kun = "";
    public String LastFound_Mean = "";
    public String LastFound_Skip = "";

    public Vector Split(String s, String sep) {
        Vector<String> v = new Vector<String>();
        int i = -1;
        int j = 0;
        i = s.indexOf(sep);
        while (i > 0) {
            v.addElement(s.substring(j, i));
            j = i + 1;
            i = s.indexOf(sep, j);
        }
        i = s.length();
        v.addElement(s.substring(j, i));
        return v;
    }

    public String FindByParam(int maxResults, int fromGrade, int toGrade, int fromStroke, int toStroke, int skip1, int skip2, int skip3, boolean includeNoGradeKanjis) {
        String res = "";
        String full_res = "";
        InputStream idxf = null;
        try {
            int i;
            idxf = this.getClass().getResourceAsStream("/main/kan/kanjidic.idx");
            while ((i = idxf.read()) != -1) {
                int kanji = (idxf.read() << 8) + i;
                int grade = idxf.read();
                int strok = idxf.read();
                int sk1 = idxf.read();
                int sk2 = idxf.read();
                int sk3 = idxf.read();
                if (grade < 0 || strok < 0 || (grade != 0 || !includeNoGradeKanjis) && (grade < fromGrade || grade > toGrade) || strok != 0 && (strok < fromStroke || strok > toStroke) || skip1 != 0 && (skip1 != sk1 || skip2 != sk2 || skip3 != sk3)) continue;
                if (res.length() >= 100) {
                    full_res = full_res + res;
                    res = "";
                }
                res = res + String.valueOf((char)kanji);
                if (--maxResults != 0) continue;
                break;
            }
            idxf.close();
            full_res = full_res + res;
            return full_res;
        }
        catch (Exception e) {
            return "";
        }
    }

    public boolean Find(char kanji) {
        char ucs = kanji;
        String ucss = Integer.toString(ucs, 16);
        if (ucss.length() != 4) {
            return false;
        }
        ucss = ucss.substring(0, 2).toUpperCase();
        try {
            int chr;
            InputStream strFile = null;
            InputStreamReader strRead = null;
            strFile = this.getClass().getResourceAsStream("/main/kan/kinf" + ucss + ".kan");
            strRead = new InputStreamReader(strFile, "UTF-8");
            strRead.read();
            StringBuffer sb = new StringBuffer();
            boolean found = false;
            boolean firstChr = true;
            while ((chr = strRead.read()) != -1) {
                if (chr != 10) {
                    if (firstChr && chr == kanji) {
                        found = true;
                    }
                    if (!found) continue;
                    sb.append((char)chr);
                    continue;
                }
                firstChr = true;
                if (!found) continue;
                this.LastEntryFound = sb.toString();
                Vector v = this.Split(this.LastEntryFound, "|");
                if (v.size() == 9) {
                    this.LastFound_Kanji = (String)v.elementAt(0);
                    this.LastFound_PicID = (String)v.elementAt(1);
                    this.LastFound_Freq = (String)v.elementAt(2);
                    this.LastFound_Grade = (String)v.elementAt(3);
                    this.LastFound_Strokes = (String)v.elementAt(4);
                    this.LastFound_Skip = (String)v.elementAt(5);
                    this.LastFound_On = (String)v.elementAt(6);
                    this.LastFound_Kun = (String)v.elementAt(7);
                    this.LastFound_Mean = (String)v.elementAt(8);
                } else {
                    this.LastFound_Kanji = "";
                    this.LastFound_PicID = "-1";
                    this.LastFound_Freq = "0";
                    this.LastFound_Grade = "0";
                    this.LastFound_Strokes = "0";
                    this.LastFound_Skip = "0-0-0";
                    this.LastFound_On = "ERROR";
                    this.LastFound_Kun = "ERROR";
                    this.LastFound_Mean = "Invalid entry";
                }
                return true;
            }
            strRead.close();
            strFile.close();
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

