/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;

public class JapStr {
    public int AscCount = 783;
    public byte[] AscData;
    public int CharCount;
    public byte[] CharData;
    private Hashtable CharPos = new Hashtable();
    public int LastX;
    public int LastY;
    private int[] Char8x16;
    private int[] Char16x16;
    private int[] Char16x32;
    private int[] Char32x32 = new int[1024];
    public int CursorType = 0;
    public boolean ProcessAlpha = false;

    public JapStr() {
        this.Char16x32 = new int[512];
        this.Char16x16 = new int[256];
        this.Char8x16 = new int[128];
        this.LoadAsciiFont();
        this.LoadJapFont();
        this.LoadCharList();
    }

    private boolean LoadAsciiFont() {
        try {
            int data;
            InputStream is = this.getClass().getResourceAsStream("/main/ufont08.fnt");
            int cnt = 0;
            this.AscData = new byte[this.AscCount * 16];
            while ((data = is.read()) != -1) {
                this.AscData[cnt] = (byte)data;
                ++cnt;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean LoadJapFont() {
        try {
            int data;
            InputStream is = this.getClass().getResourceAsStream("/main/ufont16.fnt");
            this.CharCount = data = is.read();
            data = is.read();
            this.CharCount |= data << 8;
            int cnt = 0;
            this.CharData = new byte[this.CharCount * 32];
            while ((data = is.read()) != -1) {
                this.CharData[cnt] = (byte)data;
                ++cnt;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean LoadCharList() {
        try {
            InputStream is = this.getClass().getResourceAsStream("/main/charlist.txt");
            int data = is.read();
            data = is.read();
            this.CharPos.clear();
            for (int cnt = 0; cnt < this.CharCount; ++cnt) {
                int tmp = data = is.read();
                data = is.read();
                char c = (char)(tmp |= data << 8);
                this.CharPos.put(new Integer(tmp), new IntObj(cnt));
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void drawAscChar8x16(int charId, int fore, int back) {
        int z = 0;
        int offset = (charId - 1) * 16;
        for (int y = 0; y < 16; ++y) {
            byte cdata = this.AscData[offset];
            for (int x = 0; x < 8; ++x) {
                this.Char8x16[z] = (cdata << x & 0x80) != 0 ? fore : back;
                ++z;
            }
            ++offset;
        }
    }

    public void drawAscChar16x32(int charId, int fore, int back) {
        int z = 0;
        int offset = (charId - 1) * 16;
        for (int y = 0; y < 16; ++y) {
            byte cdata = this.AscData[offset];
            for (int x = 0; x < 8; ++x) {
                if ((cdata << x & 0x80) != 0) {
                    this.Char16x32[z] = fore;
                    this.Char16x32[z + 1] = fore;
                    this.Char16x32[z + 16] = fore;
                    this.Char16x32[z + 17] = fore;
                } else {
                    this.Char16x32[z] = back;
                    this.Char16x32[z + 1] = back;
                    this.Char16x32[z + 16] = back;
                    this.Char16x32[z + 17] = back;
                }
                z += 2;
            }
            z += 16;
            ++offset;
        }
    }

    public void drawChar16x16(int charId, int fore, int back) {
        int zz = 0;
        int offset = charId * 32;
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 2; ++x) {
                int xx = x * 8;
                byte cdata = this.CharData[offset];
                for (int z = 0; z < 8; ++z) {
                    this.Char16x16[zz] = (cdata << z & 0x80) != 0 ? fore : back;
                    ++zz;
                }
                ++offset;
            }
        }
    }

    public void drawChar32x32(int charId, int fore, int back) {
        int zz = 0;
        int offset = charId * 32;
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 2; ++x) {
                int xx = x * 8;
                byte cdata = this.CharData[offset];
                for (int z = 0; z < 8; ++z) {
                    if ((cdata << z & 0x80) != 0) {
                        this.Char32x32[zz] = fore;
                        this.Char32x32[zz + 1] = fore;
                        this.Char32x32[zz + 32] = fore;
                        this.Char32x32[zz + 33] = fore;
                    } else {
                        this.Char32x32[zz] = back;
                        this.Char32x32[zz + 1] = back;
                        this.Char32x32[zz + 32] = back;
                        this.Char32x32[zz + 33] = back;
                    }
                    zz += 2;
                }
                ++offset;
            }
            zz += 32;
        }
    }

    public void drawCursor(Graphics gfx, int color, int x, int y, int w, int h) {
        switch (this.CursorType) {
            case 0: {
                gfx.setColor(color);
                gfx.fillRect(x, y + h - 4, w, h - (h - 4));
                break;
            }
            default: {
                gfx.setColor(color);
                gfx.drawRect(x, y, w - 1, h - 1);
            }
        }
    }

    public int movToMakeCursorVisible(String s, int maxCharsX, int fromChar, int cursorPos) {
        if (fromChar >= cursorPos) {
            if (cursorPos > 0) {
                return cursorPos;
            }
            return 0;
        }
        int len = s.length();
        int nchars = 0;
        for (int i = cursorPos; i > 0; --i) {
            int c = i < len ? (int)s.charAt(i) : 10;
            if (c < 12288) {
                if (c != 10) {
                    --maxCharsX;
                    ++nchars;
                }
            } else {
                maxCharsX -= 2;
                ++nchars;
            }
            if (maxCharsX > 2) continue;
            if (cursorPos - fromChar < nchars) {
                return fromChar;
            }
            return cursorPos - nchars;
        }
        return fromChar;
    }

    public int drawJapStringEx(Graphics gfx, int x0, int y0, String s, int fore, int back, int cursor, int maxCharsX, int maxRows, int fromChar, boolean rot90, int cursorFrom, int cursorTo, boolean drawCursor, boolean zoom) {
        int cW = 8;
        int cH = 16;
        if (zoom) {
            cW *= 2;
            cH *= 2;
        }
        int rev = 1;
        if (rot90) {
            rev = -1;
        }
        if (drawCursor) {
            s = s + " ";
        }
        int len = s.length() - 1;
        int x_org = x0;
        int lastPos = 0;
        int chrXCount = 0;
        int chrYCount = 0;
        for (int i = fromChar; i <= len; ++i) {
            int chrId;
            char c = s.charAt(i);
            if (c < '\u3000') {
                boolean cond3;
                boolean cond1 = chrXCount >= maxCharsX;
                boolean cond2 = c == '\n';
                boolean bl = cond3 = i >= cursorFrom && i <= cursorTo;
                if (cond1 || cond2) {
                    if (drawCursor && !cond1 && cond2 && cond3 && gfx != null) {
                        this.drawCursor(gfx, fore, x0, y0, cW, cH);
                    }
                    x0 = x_org;
                    chrXCount = 0;
                    if (cond2) {
                        y0 += cH * rev;
                        ++chrYCount;
                    }
                    if (drawCursor && cond1 && cond2 && cond3 && gfx != null) {
                        this.drawCursor(gfx, fore, x0, y0, cW, cH);
                    }
                    if (cond1) {
                        y0 += cH * rev;
                        ++chrYCount;
                    }
                    if (chrYCount >= maxRows) {
                        return lastPos + 1;
                    }
                }
                if (c > '\u001f') {
                    int[] ascChr;
                    char j = c;
                    chrId = 0;
                    if (j >= ' ' && j <= '~') {
                        chrId = j - 31;
                    }
                    if (j >= '\u00a0' && j <= '\u00ff') {
                        chrId = j - 64;
                    }
                    if (j >= '\u0100' && j <= '\u024f') {
                        chrId = j - 64;
                    }
                    if (j >= '\u1e00' && j <= '\u1eff') {
                        chrId = j - 7152;
                    }
                    if (!zoom) {
                        this.drawAscChar8x16(chrId, fore, back);
                        ascChr = this.Char8x16;
                    } else {
                        this.drawAscChar16x32(chrId, fore, back);
                        ascChr = this.Char16x32;
                    }
                    if (!rot90 && gfx != null) {
                        gfx.drawRGB(ascChr, 0, cW, x0, y0, cW, cH, this.ProcessAlpha);
                        if (drawCursor && cond3) {
                            this.drawCursor(gfx, fore, x0, y0, cW, cH);
                        }
                    }
                    x0 += cW;
                    ++chrXCount;
                }
                lastPos = i;
            } else {
                int[] japChr;
                if (chrXCount >= maxCharsX - 1) {
                    x0 = x_org;
                    y0 += cH * rev;
                    chrXCount = 0;
                    if (++chrYCount == maxRows) {
                        return lastPos + 1;
                    }
                }
                chrId = 0;
                IntObj ipos = (IntObj)this.CharPos.get(new Integer(c));
                if (ipos != null) {
                    chrId = ipos.Value;
                }
                if (!zoom) {
                    this.drawChar16x16(chrId, fore, back);
                    japChr = this.Char16x16;
                } else {
                    this.drawChar32x32(chrId, fore, back);
                    japChr = this.Char32x32;
                }
                if (!rot90 && gfx != null) {
                    gfx.drawRGB(japChr, 0, cH, x0, y0, cH, cH, this.ProcessAlpha);
                    if (drawCursor & i >= cursorFrom & i <= cursorTo) {
                        this.drawCursor(gfx, fore, x0, y0, cH, cH);
                    }
                }
                x0 += cH;
                chrXCount += 2;
                lastPos = i;
            }
            this.LastX = x0;
            this.LastY = y0;
        }
        return -1;
    }

    public int drawJapString(Graphics gfx, int x0, int y0, String s, int fore, int back, int maxCharsX, int maxRows, int fromChar, boolean rot90, boolean zoom) {
        return this.drawJapStringEx(gfx, x0, y0, s, fore, back, 0, maxCharsX, maxRows, fromChar, rot90, 0, 0, false, zoom);
    }

    private class IntObj {
        public int Value;

        public IntObj(int val) {
            this.Value = val;
        }
    }
}

