/*
 * Decompiled with CFR 0.152.
 */
package main;

import javax.microedition.lcdui.Graphics;
import main.JapControl;
import main.JapForm;

public class JapSpin
extends JapControl {
    private int Value = 0;
    private int MinValue = 0;
    private int MaxValue = 9;

    public JapSpin(JapForm parent, int formID, int left, int top, int width, int height, int value, int min, int max) {
        this.Type = parent.JAP_CTRL_TYPE_SPIN;
        this.Parent = parent;
        this.FormID = formID;
        this.Left = left * parent.CellSize;
        this.Top = top * (parent.CellSize * 2);
        this.Width = width;
        this.Height = height;
        this.AdvDrawing = false;
        this.CanFocus = true;
        this.CanLockFocus = true;
        this.LockOnFocus = true;
        this.LockOnUpDown = true;
        this.UnlockOnLeftRight = true;
        this.Value = value;
        this.MinValue = min;
        this.MaxValue = max;
    }

    public void setValue(int v) {
        if (v > this.MaxValue) {
            v = this.MaxValue;
        }
        if (v < this.MinValue) {
            v = this.MinValue;
        }
        this.Value = v;
    }

    public int getValue() {
        return this.Value;
    }

    public void run() {
    }

    public void paint(Graphics g) {
        if (!this.Visible | this.Parent.CurrentFormID != this.FormID) {
            return;
        }
        int fore = this.Color;
        int back = this.BackColor;
        if (this.Parent.FocusedControl == this) {
            fore = this.Parent.SelectionColor;
            back = this.Parent.SelectionBackColor;
        }
        g.setColor(back);
        g.fillRect(this.Left, this.Top, this.Width * this.Parent.CellSize, this.Height * this.Parent.CellSize * 2);
        String s = Integer.toString(this.Value);
        while (s.length() < this.Width - 1) {
            s = " " + s;
        }
        this.Parent.JPStr.ProcessAlpha = this.AdvDrawing;
        this.Parent.JPStr.drawJapString(g, this.Left, this.Top, s, fore, back, this.Width - 1, this.Height, 0, false, this.Parent.Zoom);
        int x_src = this.Left + (this.Width - 1) * this.Parent.CellSize;
        g.setColor(fore);
        for (int y = 1; y < 4; ++y) {
            int y0 = this.Top + y + 3;
            int y1 = this.Top + 13 - y;
            int x0 = x_src + 4 - y;
            int x1 = x_src + 3 + y;
            g.drawLine(x0, y0, x1, y0);
            g.drawLine(x0, y1, x1, y1);
        }
    }

    public boolean keyPressed(int keyCode) {
        switch (keyCode) {
            case 1001: {
                this.setValue(this.Value - 1);
                break;
            }
            case 1000: {
                this.setValue(this.Value + 1);
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                String s = Integer.toString(this.Value) + Integer.toString(keyCode - 48);
                String max = Integer.toString(this.MaxValue);
                while (s.length() > max.length()) {
                    s = s.substring(1);
                }
                this.setValue(Integer.parseInt(s));
            }
        }
        return true;
    }
}

