/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.InputStream;
import java.io.InputStreamReader;

public class JapRevQuery {
    public static final int SEARCH_MODE_MATCH = 0;
    public static final int SEARCH_MODE_BEGINS_WIDTH = 1;
    public int EntryCount;
    private String[] Entry;
    private int IndexNumber = -1;
    private InputStream IndexFile = null;
    private InputStreamReader IndexFileReader = null;
    private int LastSearchMode = 0;
    private String LastWord = "";
    private int LastWordLen = 0;
    private String LastFound = "";
    private boolean LastMatch = false;
    private boolean ReadingWord = true;

    public JapRevQuery() {
        this.LoadIndex();
    }

    private boolean LoadIndex() {
        StringBuffer sb = new StringBuffer();
        try {
            int chr;
            InputStream iss = this.getClass().getResourceAsStream("/main/xxx/xxx.tin");
            InputStreamReader is = new InputStreamReader(iss, "UTF-8");
            int rowNum = 0;
            is.read();
            while ((chr = is.read()) != -1) {
                if (chr == 10) {
                    String line = sb.toString();
                    if (rowNum == 0) {
                        this.EntryCount = Integer.parseInt(line);
                        this.Entry = new String[this.EntryCount];
                    } else {
                        this.Entry[rowNum - 1] = line;
                    }
                    sb.setLength(0);
                    ++rowNum;
                    continue;
                }
                if (chr == 13) continue;
                sb.append((char)chr);
            }
            is.close();
            iss.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean OpenCurrentIndex() {
        try {
            if (this.IndexFile != null) {
                this.IndexFileReader.close();
                this.IndexFile.close();
                this.IndexFileReader = null;
                this.IndexFile = null;
            }
            this.IndexFile = this.getClass().getResourceAsStream("/main/xxx/xxx" + String.valueOf(this.IndexNumber) + ".tin");
            this.IndexFileReader = new InputStreamReader(this.IndexFile, "UTF-8");
            this.IndexFileReader.read();
            this.ReadingWord = true;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private int LastEntryMatch() {
        int match = -1;
        switch (this.LastSearchMode) {
            case 0: {
                match = this.LastFound.compareTo(this.LastWord);
                break;
            }
            case 1: {
                if (this.LastFound.length() < this.LastWordLen) break;
                String sub = this.LastFound.substring(0, this.LastWordLen);
                match = sub.compareTo(this.LastWord);
            }
        }
        return match;
    }

    public int FindNext() {
        StringBuffer sb = new StringBuffer();
        try {
            while (this.IndexNumber <= this.EntryCount) {
                int chr;
                block7: while ((chr = this.IndexFileReader.read()) != -1) {
                    if (chr == 10) {
                        this.ReadingWord = true;
                        chr = 44;
                    }
                    switch (chr) {
                        case 47: {
                            this.ReadingWord = false;
                            this.LastFound = sb.toString();
                            sb.setLength(0);
                            int match = this.LastEntryMatch();
                            boolean bl = this.LastMatch = match == 0;
                            if (match <= 0) continue block7;
                            return 0;
                        }
                        case 44: {
                            if (!this.LastMatch) continue block7;
                            int dict_index = Integer.parseInt(sb.toString(), 16);
                            sb.setLength(0);
                            return dict_index;
                        }
                    }
                    if (!(this.ReadingWord | this.LastMatch)) continue;
                    sb.append((char)chr);
                }
                if (this.LastSearchMode != 1) continue;
                ++this.IndexNumber;
                if (this.IndexNumber > this.EntryCount || this.OpenCurrentIndex()) continue;
                return -1;
            }
        }
        catch (Exception e) {
            return -1;
        }
        return 0;
    }

    public int GetIndexNumber(String word) {
        int idx = -1;
        int res = -1;
        for (int i = 0; i < this.EntryCount; ++i) {
            res = this.Entry[i].compareTo(word);
            if (res < 0) continue;
            idx = i - 1;
            break;
        }
        if (idx < 0) {
            idx = this.EntryCount - 1;
        }
        return idx;
    }

    public int FindFirst(String word) {
        this.LastWord = word;
        this.LastFound = "";
        this.LastMatch = false;
        this.LastSearchMode = 0;
        char clast = word.charAt(word.length() - 1);
        if (clast == '*') {
            this.LastSearchMode = 1;
            this.LastWord = word.substring(0, word.length() - 1);
        }
        this.LastWordLen = this.LastWord.length();
        if (this.LastWordLen == 0) {
            return 0;
        }
        this.IndexNumber = this.GetIndexNumber(this.LastWord);
        if (!this.OpenCurrentIndex()) {
            return -1;
        }
        return this.FindNext();
    }
}

