/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import main.JapControl;
import main.JapForm;

public class JapList
extends JapControl {
    private Image Pic = null;
    public boolean UseIndexNumbers = false;
    public boolean DrawScrollBar = true;
    private Vector Items = new Vector();
    private Vector Icons = new Vector();
    private String ItemStr = "";
    public int SelectedItem = -1;
    private int VisibleRows;
    private int VisibleFirst;
    private int Columns;
    private int ColumnSize;

    public JapList(JapForm parent, int formID, int columns, int colSize, int left, int top, int width, int height) {
        this.Type = parent.JAP_CTRL_TYPE_LIST;
        this.Parent = parent;
        this.FormID = formID;
        this.Left = left * parent.CellSize;
        this.Top = top * (parent.CellSize * 2);
        this.Width = width;
        this.Height = height;
        this.AdvDrawing = this.Parent.AdvDrawing;
        this.CanFocus = true;
        this.CanLockFocus = true;
        this.BackColor = -1118482;
        this.BackColor2 = -7829368;
        this.Color2 = this.BackColor & 0xFFFFFF;
        this.VisibleFirst = 0;
        this.VisibleRows = this.Height;
        this.Columns = columns;
        this.ColumnSize = colSize;
    }

    public boolean loadIcons(String src) {
        try {
            this.Pic = Image.createImage((String)src);
            return true;
        }
        catch (Exception e) {
            this.Pic = null;
            return false;
        }
    }

    public int addItemEx(String text, int icon) {
        this.Items.addElement(text);
        if (icon >= 0) {
            this.Icons.addElement(new Integer(icon));
        }
        if (this.SelectedItem < 0) {
            this.SelectedItem = 0;
        }
        return this.size() - 1;
    }

    public int addItem(String text) {
        return this.addItemEx(text, -1);
    }

    public void removeAll() {
        this.VisibleFirst = 0;
        this.SelectedItem = -1;
        this.ItemStr = "";
        this.Items.removeAllElements();
        this.Items.trimToSize();
        this.Icons.removeAllElements();
        this.Icons.trimToSize();
    }

    public void ensureCapacity(int minCapacity) {
        this.Items.ensureCapacity(minCapacity);
    }

    public int size() {
        if (this.ItemStr == "") {
            return this.Items.size();
        }
        return this.ItemStr.length();
    }

    public String getItemStr(int index) {
        if (index >= 0 && index < this.size()) {
            if (this.ItemStr == "") {
                return (String)this.Items.elementAt(index);
            }
            return String.valueOf(this.ItemStr.charAt(index));
        }
        return "";
    }

    public void setItemStr(String s) {
        this.ItemStr = s;
        if (s.length() > 0) {
            this.SelectedItem = 0;
        }
    }

    public void setLinkedItems(Vector items) {
        this.removeAll();
        this.Items = null;
        this.Items = items;
        if (this.size() > 0) {
            this.SelectedItem = 0;
        }
    }

    public void run() {
    }

    public void paint(Graphics g) {
        boolean needsScrollBar;
        if (!this.Visible | this.Parent.CurrentFormID != this.FormID) {
            return;
        }
        int cW = this.Parent.CellSize;
        int cH = this.Parent.CellSize * 2;
        int item_count = this.size();
        int fore1 = this.Color;
        int fore2 = this.Color2;
        int back1 = this.BackColor;
        int back2 = this.BackColor2;
        if (this.Parent.FocusedControl == this) {
            if (this.Parent.FocusLocked) {
                fore1 = this.Parent.LockedColor;
                fore2 = this.Parent.LockedColor2;
                back1 = this.Parent.LockedBackColor;
                back2 = this.Parent.LockedBackColor2;
            } else {
                fore1 = this.Parent.SelectionColor;
                fore2 = this.Parent.SelectionColor2;
                back1 = this.Parent.SelectionBackColor;
                back2 = this.Parent.SelectionBackColor2;
            }
        }
        this.Parent.drawRect(g, this.AdvDrawing, back1, back2, this.Left, this.Top, this.Width * cW, this.Height * cH);
        int y_pos = 0;
        int i = this.VisibleFirst;
        int w = this.Width;
        boolean multiCol = this.Columns > 1;
        boolean bl = needsScrollBar = this.DrawScrollBar && !multiCol && item_count > this.VisibleRows;
        if (multiCol) {
            w = this.ColumnSize;
        }
        if (needsScrollBar) {
            --w;
        }
        while (i < this.VisibleFirst + this.VisibleRows * this.Columns & i < item_count) {
            int x_pos;
            int f1 = fore1;
            int f2 = fore2;
            int b1 = back1;
            int b2 = back2;
            int idx = i - this.VisibleFirst;
            if (!multiCol) {
                x_pos = this.Left;
                y_pos = this.Top + idx * cH;
            } else {
                x_pos = this.Left + idx % this.Columns * this.ColumnSize * cW;
                y_pos = this.Top + idx / this.Columns * cH;
            }
            if (this.SelectedItem == i) {
                int tmp = f1;
                f1 = b1;
                f2 = b1 = tmp;
                b2 = b1;
                this.Parent.drawRect(g, this.AdvDrawing, b1, b1, x_pos, y_pos, w * cW, cH);
            }
            if (i >= 0 && i < item_count) {
                String item_str = this.getItemStr(i);
                Integer icon = null;
                if (i < this.Icons.size()) {
                    icon = (Integer)this.Icons.elementAt(i);
                }
                if (!multiCol && icon != null && icon >= 0 && this.Pic != null) {
                    g.drawRegion(this.Pic, icon * 16, 0, 16, 16, 0, x_pos, y_pos, 20);
                    x_pos += 16;
                }
                this.Parent.JPStr.ProcessAlpha = this.AdvDrawing;
                this.Parent.JPStr.drawJapStringEx(g, x_pos, y_pos, item_str, f1, f2, 0, w, 1, 0, false, -1, -1, false, this.Parent.Zoom);
            }
            ++i;
        }
        if (needsScrollBar) {
            g.setColor(fore1);
            int x0 = this.Left + (this.Width - 1) * cW;
            int h0 = this.Height * cH;
            g.fillRect(x0, this.Top, cW, h0);
            g.setColor(back1);
            int h1 = h0 / item_count;
            if (h1 < 1) {
                h1 = 2;
            }
            int t1 = this.SelectedItem * h0 / item_count;
            g.fillRect(x0 + 1, this.Top + t1, cW - 2, h1);
        }
    }

    private void beSureCursorIsVisible() {
        if (this.SelectedItem < 0) {
            return;
        }
        if (this.Columns > 1) {
            if (this.SelectedItem > this.VisibleFirst + this.VisibleRows * this.Columns - 1) {
                this.VisibleFirst = this.SelectedItem / this.Columns * this.Columns - (this.VisibleRows - 1) * this.Columns;
            }
            if (this.SelectedItem < this.VisibleFirst) {
                this.VisibleFirst = this.SelectedItem / this.Columns * this.Columns;
            }
        } else {
            if (this.SelectedItem > this.VisibleFirst + this.VisibleRows - 1) {
                this.VisibleFirst = this.SelectedItem - (this.VisibleRows - 1);
            }
            if (this.SelectedItem < this.VisibleFirst) {
                this.VisibleFirst = this.SelectedItem;
            }
        }
    }

    public void setSelectedItem(int index) {
        if (index < 0) {
            index = -1;
        }
        if (index >= this.size()) {
            index = this.size() - 1;
        }
        this.SelectedItem = index;
        this.beSureCursorIsVisible();
    }

    public void movePrev() {
        if (this.size() <= 0) {
            return;
        }
        --this.SelectedItem;
        if (this.SelectedItem < 0) {
            this.SelectedItem = this.size() - 1;
        }
        this.beSureCursorIsVisible();
    }

    public void moveNext() {
        if (this.size() <= 0) {
            return;
        }
        this.SelectedItem = (this.SelectedItem + 1) % this.size();
        this.beSureCursorIsVisible();
    }

    public void moveRowUp() {
        if (this.size() <= 0) {
            return;
        }
        this.SelectedItem -= this.Columns;
        if (this.SelectedItem < 0) {
            this.SelectedItem = this.size() - 1;
        }
        this.beSureCursorIsVisible();
    }

    public void moveRowDown() {
        if (this.size() <= 0) {
            return;
        }
        this.SelectedItem = (this.SelectedItem + this.Columns) % this.size();
        this.beSureCursorIsVisible();
    }

    public void movePgDown() {
        if (this.size() <= 0) {
            return;
        }
        if (this.SelectedItem == this.size() - 1) {
            this.SelectedItem = 0;
        } else {
            this.SelectedItem += this.Columns * this.VisibleRows;
            if (this.SelectedItem >= this.size()) {
                this.SelectedItem = this.size() - 1;
            }
        }
        this.beSureCursorIsVisible();
    }

    public boolean keyPressed(int keyCode) {
        if (!this.Visible | this.Parent.CurrentFormID != this.FormID) {
            return true;
        }
        boolean multiCol = this.Columns > 1;
        switch (keyCode) {
            case 1000: {
                if (!multiCol) {
                    this.movePrev();
                    break;
                }
                this.moveRowUp();
                break;
            }
            case 1001: {
                if (!multiCol) {
                    this.moveNext();
                    break;
                }
                this.moveRowDown();
                break;
            }
            case 1002: {
                if (!multiCol) break;
                this.movePrev();
                break;
            }
            case 1003: {
                if (!multiCol) break;
                this.moveNext();
            }
        }
        if (this.UseIndexNumbers && !multiCol) {
            switch (keyCode) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    int pos = keyCode - 49;
                    if (pos < 0) {
                        pos = 9;
                    }
                    if (pos >= this.size()) break;
                    this.SelectedItem = pos;
                    this.beSureCursorIsVisible();
                }
            }
        }
        return true;
    }
}

