/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class JapInput {
    public int ReadingCount = 0;
    public String[] Reading;
    public String[] ReadingKanjis;
    public String[] CharInputA;
    public String[] CharInputK;
    public String[] CharInputH;

    public JapInput() {
        this.LoadCharInput();
        this.LoadReadings();
    }

    private boolean LoadReadings() {
        StringBuffer sb = new StringBuffer();
        try {
            int chr;
            InputStream iss = this.getClass().getResourceAsStream("/main/readings.txt");
            InputStreamReader is = new InputStreamReader(iss, "UTF-8");
            int rowNum = 0;
            is.read();
            while ((chr = is.read()) != -1) {
                if (chr == 10) {
                    String line = sb.toString();
                    if (rowNum == 0) {
                        this.ReadingCount = Integer.parseInt(line);
                        this.Reading = new String[this.ReadingCount];
                        this.ReadingKanjis = new String[this.ReadingCount];
                    } else {
                        int sep = line.indexOf(32);
                        this.Reading[rowNum - 1] = line.substring(0, sep);
                        this.ReadingKanjis[rowNum - 1] = line.substring(sep + 1, line.length());
                    }
                    sb.setLength(0);
                    ++rowNum;
                    continue;
                }
                if (chr == 13) continue;
                sb.append((char)chr);
            }
            is.close();
            iss.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Vector Split(String s, String sep) {
        Vector<String> v = new Vector<String>();
        int i = -1;
        int j = 0;
        i = s.indexOf(sep);
        while (i > 0) {
            v.addElement(s.substring(j, i));
            j = i + 1;
            i = s.indexOf(sep, j);
        }
        i = s.length();
        v.addElement(s.substring(j, i));
        return v;
    }

    private boolean LoadCharInput() {
        StringBuffer sb = new StringBuffer();
        try {
            int chr;
            this.CharInputA = new String[128];
            this.CharInputK = new String[128];
            this.CharInputH = new String[128];
            InputStream iss = this.getClass().getResourceAsStream("/main/charinput2.txt");
            InputStreamReader is = new InputStreamReader(iss, "UTF-8");
            is.read();
            while ((chr = is.read()) != -1) {
                if (chr == 10) {
                    String line = sb.toString();
                    Vector v = this.Split(line, "|");
                    if (v.size() == 4) {
                        int keyId = Integer.parseInt((String)v.elementAt(0));
                        this.CharInputA[keyId] = (String)v.elementAt(1);
                        this.CharInputK[keyId] = (String)v.elementAt(2);
                        this.CharInputH[keyId] = (String)v.elementAt(3);
                    }
                    sb.setLength(0);
                    continue;
                }
                if (chr == 13) continue;
                sb.append((char)chr);
            }
            is.close();
            iss.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public char RotateKana(char c) {
        switch (c) {
            case '\u304b': 
            case '\u304d': 
            case '\u304f': 
            case '\u3051': 
            case '\u3053': 
            case '\u3055': 
            case '\u3057': 
            case '\u3059': 
            case '\u305b': 
            case '\u305d': 
            case '\u305f': 
            case '\u3061': 
            case '\u3064': 
            case '\u3066': 
            case '\u3068': 
            case '\u306f': 
            case '\u3070': 
            case '\u3072': 
            case '\u3073': 
            case '\u3075': 
            case '\u3076': 
            case '\u3078': 
            case '\u3079': 
            case '\u307b': 
            case '\u307c': 
            case '\u30ab': 
            case '\u30ad': 
            case '\u30af': 
            case '\u30b1': 
            case '\u30b3': 
            case '\u30b5': 
            case '\u30b7': 
            case '\u30b9': 
            case '\u30bb': 
            case '\u30bd': 
            case '\u30bf': 
            case '\u30c1': 
            case '\u30c4': 
            case '\u30c6': 
            case '\u30c8': 
            case '\u30cf': 
            case '\u30d0': 
            case '\u30d2': 
            case '\u30d3': 
            case '\u30d5': 
            case '\u30d6': 
            case '\u30d8': 
            case '\u30d9': 
            case '\u30db': 
            case '\u30dc': {
                return (char)(c + '\u0001');
            }
            case '\u304c': 
            case '\u304e': 
            case '\u3050': 
            case '\u3052': 
            case '\u3054': 
            case '\u3056': 
            case '\u3058': 
            case '\u305a': 
            case '\u305c': 
            case '\u305e': 
            case '\u3060': 
            case '\u3062': 
            case '\u3065': 
            case '\u3067': 
            case '\u3069': 
            case '\u30ac': 
            case '\u30ae': 
            case '\u30b0': 
            case '\u30b2': 
            case '\u30b4': 
            case '\u30b6': 
            case '\u30b8': 
            case '\u30ba': 
            case '\u30bc': 
            case '\u30be': 
            case '\u30c0': 
            case '\u30c2': 
            case '\u30c5': 
            case '\u30c7': 
            case '\u30c9': {
                return (char)(c - '\u0001');
            }
            case '\u3071': 
            case '\u3074': 
            case '\u3077': 
            case '\u307a': 
            case '\u307d': 
            case '\u30d1': 
            case '\u30d4': 
            case '\u30d7': 
            case '\u30da': 
            case '\u30dd': {
                return (char)(c - 2);
            }
        }
        return '\u0000';
    }

    public String FindKanjiTableByReading(String s) {
        for (int i = 0; i < this.ReadingCount; ++i) {
            if (this.Reading[i].compareTo(s) != 0) continue;
            return this.ReadingKanjis[i];
        }
        return "";
    }
}

