/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import main.JapControl;
import main.JapEdit;
import main.JapInput;
import main.JapStr;

public class JapForm
implements Runnable {
    public static final int MAIN_KEY_UP = 1000;
    public static final int MAIN_KEY_DOWN = 1001;
    public static final int MAIN_KEY_LEFT = 1002;
    public static final int MAIN_KEY_RIGHT = 1003;
    public static final int MAIN_KEY_FIRE = 1004;
    public static final int MAIN_KEY_LCMD = 1005;
    public static final int MAIN_KEY_RCMD = 1006;
    public static final int MAIN_KEY_CANCEL = 1007;
    public static final int MAIN_KEY_SWITCH = 1008;
    public int STEP_RUN = 66;
    public int JAP_CTRL_TYPE_LABEL = 1;
    public int JAP_CTRL_TYPE_EDIT = 2;
    public int JAP_CTRL_TYPE_LIST = 3;
    public int JAP_CTRL_TYPE_PIC = 4;
    public int JAP_CTRL_TYPE_SPIN = 5;
    public int JAP_CTRL_TYPE_CHECK = 6;
    public int CurrentFormID = -1;
    public Vector Forms = new Vector();
    public Vector Controls = new Vector();
    public JapStr JPStr;
    public JapInput JPInput;
    public Canvas Canv;
    public int SelectionColor = -1;
    public int SelectionBackColor = -16777088;
    public int SelectionBackColor2 = -16777152;
    public int SelectionColor2 = this.SelectionBackColor & 0xFFFFFF;
    public int LockedColor = -1;
    public int LockedBackColor = -8388608;
    public int LockedBackColor2 = -12582912;
    public int LockedColor2 = this.LockedBackColor & 0xFFFFFF;
    public JapControl FocusedControl;
    public boolean FocusLocked = false;
    private int FocusedControlIndex;
    public int[] KeyMain = new int[9];
    public boolean Zoom;
    public int CellSize;
    public int CharColumns;
    public int CharRows;
    public boolean AdvDrawing = false;

    public JapForm(boolean zoom, JapStr jpstr, JapInput jpinput, Canvas c) {
        this.JPStr = jpstr;
        this.JPInput = jpinput;
        this.Canv = c;
        this.FocusedControlIndex = -1;
        this.Zoom = zoom;
        this.CellSize = !this.Zoom ? 8 : 16;
        this.CharColumns = c.getWidth() / this.CellSize;
        this.CharRows = c.getHeight() / (this.CellSize * 2);
        new Thread(this).start();
    }

    public int addForm(boolean focusLocked) {
        this.Forms.addElement(new JForm(focusLocked));
        return this.Forms.size() - 1;
    }

    public int addControl(JapControl control) {
        this.Controls.addElement(control);
        return this.Controls.size() - 1;
    }

    public int translateKey(int keyCode) {
        for (int i = 0; i < this.KeyMain.length; ++i) {
            if (keyCode != this.KeyMain[i]) continue;
            return i + 1000;
        }
        return keyCode;
    }

    public void paint(Graphics g) {
        for (int i = 0; i < this.Controls.size(); ++i) {
            JapControl control = (JapControl)this.Controls.elementAt(i);
            if (control == null || !(control.Visible & control.FormID == this.CurrentFormID)) continue;
            control.paint(g);
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    long start = System.currentTimeMillis();
                    for (int i = 0; i < this.Controls.size(); ++i) {
                        JapControl control = (JapControl)this.Controls.elementAt(i);
                        if (control == null || !(control.Visible & control.FormID == this.CurrentFormID)) continue;
                        control.run();
                    }
                    long end = System.currentTimeMillis();
                    long elapsed = end - start;
                    if (elapsed < (long)this.STEP_RUN) {
                        // empty if block
                    }
                    this.Canv.repaint();
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private void FindNextControl(int dir) {
        int i = this.FocusedControlIndex;
        int first = this.FocusedControlIndex;
        if (first < 0) {
            first = this.Controls.size() - 1;
        }
        do {
            JapControl control;
            if ((i += 1 * dir) >= this.Controls.size()) {
                i = 0;
            }
            if (i < 0) {
                i = this.Controls.size() - 1;
            }
            if ((control = (JapControl)this.Controls.elementAt(i)) == null || !(control.CanFocus & control.Visible & control.FormID == this.CurrentFormID)) continue;
            this.FocusedControl = control;
            this.FocusedControlIndex = i;
            if (!control.LockOnFocus) break;
            this.FocusLocked = true;
            break;
        } while (i != first);
    }

    private void FindNextControl() {
        this.FindNextControl(1);
    }

    private void FindPrevControl() {
        this.FindNextControl(-1);
    }

    public boolean keyPressed(int keyCode) {
        boolean pressed = true;
        keyCode = this.translateKey(keyCode);
        if (!this.FocusLocked && this.FocusedControl != null) {
            if (this.FocusedControl.LockOnUpDown && keyCode >= 1000 && keyCode <= 1001) {
                this.FocusLocked = true;
            }
            if (this.FocusedControl.LockOnNumPad && keyCode >= 48 && keyCode <= 57) {
                this.FocusLocked = true;
            }
        }
        if (this.FocusLocked && this.FocusedControl != null) {
            if (this.FocusedControl.UnlockOnUpDown && keyCode >= 1000 && keyCode <= 1001) {
                this.FocusLocked = false;
            }
            if (this.FocusedControl.UnlockOnLeftRight && keyCode >= 1002 && keyCode <= 1003) {
                this.FocusLocked = false;
            }
        }
        if (this.FocusLocked) {
            if (this.FocusedControl != null) {
                pressed = this.FocusedControl.keyPressed(keyCode);
                if (keyCode == 1004 & this.FocusedControl.UnlockOnFire) {
                    this.FocusLocked = false;
                }
            } else {
                this.FocusLocked = false;
            }
        } else if (this.FocusedControl != null) {
            switch (keyCode) {
                case 1004: {
                    if (!this.FocusLocked) {
                        if (!this.FocusedControl.CanLockFocus) break;
                        this.FocusLocked = true;
                        break;
                    }
                    this.FocusLocked = false;
                    break;
                }
                case 1000: {
                    if (!this.FocusLocked && this.FocusedControl.Type == this.JAP_CTRL_TYPE_EDIT) {
                        JapEdit edit = (JapEdit)this.FocusedControl;
                        if (edit.isBOFVisible()) break;
                        edit.scrollUp();
                        break;
                    }
                }
                case 1002: {
                    this.FindPrevControl();
                    break;
                }
                case 1001: {
                    if (!this.FocusLocked && this.FocusedControl.Type == this.JAP_CTRL_TYPE_EDIT) {
                        JapEdit edit = (JapEdit)this.FocusedControl;
                        if (edit.isEOFVisible()) break;
                        edit.scrollDown();
                        break;
                    }
                }
                case 1003: {
                    this.FindNextControl();
                }
            }
        } else {
            this.FindNextControl();
        }
        return pressed;
    }

    public void ChangeForm(int formID) {
        if (this.CurrentFormID >= 0) {
            JForm prev_frm = (JForm)this.Forms.elementAt(this.CurrentFormID);
            prev_frm.LastFocusedControl = this.FocusedControl;
            prev_frm.LastFocusedControlIndex = this.FocusedControlIndex;
            prev_frm.FocusLocked = this.FocusLocked;
        }
        this.CurrentFormID = formID;
        JForm next_frm = (JForm)this.Forms.elementAt(formID);
        this.FocusedControl = next_frm.LastFocusedControl;
        this.FocusedControlIndex = next_frm.LastFocusedControlIndex;
        this.FocusLocked = next_frm.FocusLocked;
        if (this.FocusedControl == null) {
            this.FindNextControl();
        }
    }

    public JapEdit GetControl_Edit(JapControl control) {
        if (control != null && control.Type == this.JAP_CTRL_TYPE_EDIT) {
            JapEdit edit = (JapEdit)control;
            return edit;
        }
        return null;
    }

    public JapEdit GetLastFocusedControl_Edit(int formID) {
        Object obj = this.Forms.elementAt(formID);
        if (obj != null) {
            JForm frm = (JForm)obj;
            if (frm.LastFocusedControl != null) {
                return this.GetControl_Edit(frm.LastFocusedControl);
            }
        }
        return null;
    }

    public boolean setFocusedControl(JapControl control, boolean locked) {
        if (control == null) {
            this.FocusedControl = null;
            this.FocusLocked = false;
            this.FocusedControlIndex = -1;
            return true;
        }
        if (control.FormID != this.CurrentFormID) {
            return false;
        }
        this.FocusedControl = control;
        this.FocusLocked = locked;
        this.FocusedControlIndex = this.Controls.indexOf(control);
        return true;
    }

    public String GetCommandString(String left, String center, String right) {
        String s = "";
        String sep1 = " ";
        String sep2 = " ";
        String l = "";
        String c = "";
        String r = "";
        int lenC = center.length();
        int lenL = left.length();
        int lenR = right.length();
        int i = 0;
        s = l + sep1 + c + sep2 + r;
        while (s.length() < this.CharColumns) {
            s = l + sep1 + c + sep2 + r;
            if (c.length() == lenC & l.length() == lenL & r.length() == lenR) {
                switch (i % 2) {
                    case 0: {
                        sep1 = sep1 + " ";
                        break;
                    }
                    case 1: {
                        sep2 = sep2 + " ";
                    }
                }
            } else {
                switch (i % 3) {
                    case 0: {
                        if (!(lenC > 0 & c.length() < lenC)) break;
                        c = center.substring(0, c.length() + 1);
                        break;
                    }
                    case 1: {
                        if (!(lenL > 0 & l.length() < lenL)) break;
                        l = left.substring(0, l.length() + 1);
                        break;
                    }
                    case 2: {
                        if (!(lenR > 0 & r.length() < lenR)) break;
                        r = right.substring(0, r.length() + 1);
                    }
                }
            }
            ++i;
        }
        return s;
    }

    private int blendColors(int a, int b, float ratio) {
        int b0 = a & 0xFF;
        int b1 = b & 0xFF;
        int bf = b0 + (int)((float)(b1 - b0) * ratio);
        int g0 = a >> 8 & 0xFF;
        int g1 = b >> 8 & 0xFF;
        int gf = g0 + (int)((float)(g1 - g0) * ratio);
        int r0 = a >> 16 & 0xFF;
        int r1 = b >> 16 & 0xFF;
        int rf = r0 + (int)((float)(r1 - r0) * ratio);
        return 0xFF000000 | rf << 16 | gf << 8 | bf;
    }

    public void drawRect(Graphics g, boolean adv, int color1, int color2, int x, int y, int w, int h) {
        if (!adv || !this.AdvDrawing || color1 == color2) {
            g.setColor(color1);
            g.fillRect(x, y, w, h);
        } else {
            for (int i = 0; i < h; ++i) {
                int col = this.blendColors(color1, color2, (float)i / (float)h);
                g.setColor(col);
                g.fillRect(x, y + i, w, 1);
            }
        }
    }

    public class JForm {
        public JapControl LastFocusedControl = null;
        public int LastFocusedControlIndex = -1;
        public boolean FocusLocked = false;

        public JForm(boolean focusLocked) {
            this.FocusLocked = focusLocked;
            JapForm.this.KeyMain[0] = -1;
            JapForm.this.KeyMain[1] = -2;
            JapForm.this.KeyMain[2] = -3;
            JapForm.this.KeyMain[3] = -4;
            JapForm.this.KeyMain[4] = -5;
            JapForm.this.KeyMain[5] = -6;
            JapForm.this.KeyMain[6] = -7;
            JapForm.this.KeyMain[7] = -8;
            JapForm.this.KeyMain[8] = -26;
        }
    }
}

