/*
 * Decompiled with CFR 0.152.
 */
package main;

import javax.microedition.lcdui.Graphics;
import main.JapControl;
import main.JapForm;
import main.JapLabel;

public class JapEdit
extends JapControl {
    public static final int INPUT_MODE_COUNT = 4;
    public static final int INPUT_MODE_ASCII = 0;
    public static final int INPUT_MODE_KATA = 1;
    public static final int INPUT_MODE_HIRA = 2;
    public static final int INPUT_MODE_KANJI = 3;
    public String Text;
    private int CursorPos;
    private int CursorPosKanji = -1;
    private int TextOffset = 0;
    public int InputMode;
    public boolean CharInputWIP;
    public String CharInputStr;
    public long CharInputTime;
    public int CharInputPos;
    public int CharInputKeyCode;
    public boolean KanjiSelectionWIP;
    public JapLabel InputPreview;
    private boolean EOFVisible = false;

    public JapEdit(JapForm parent, int formID, String text, int left, int top, int width, int height) {
        this.Type = parent.JAP_CTRL_TYPE_EDIT;
        this.Parent = parent;
        this.FormID = formID;
        this.Text = text;
        this.Left = left * parent.CellSize;
        this.Top = top * (parent.CellSize * 2);
        this.Width = width;
        this.Height = height;
        this.AdvDrawing = false;
        this.CanFocus = true;
        this.CanLockFocus = true;
        this.CursorPos = 0;
        this.InputMode = 0;
        this.CharInputWIP = false;
        this.CharInputStr = "";
        this.CharInputTime = 0L;
        this.CharInputPos = 0;
        this.CharInputKeyCode = 0;
    }

    public void SetText(String s, boolean moveCursorToTheEnd) {
        this.Text = s;
        this.TextOffset = 0;
        if (moveCursorToTheEnd) {
            this.setCursorPos(s.length(), true);
        } else {
            this.setCursorPos(0, true);
        }
    }

    private void finishCharInput(boolean moveCur) {
        if (this.KanjiSelectionWIP) {
            this.finishKanjiInputSelectionSubmode(false);
        }
        if (this.CharInputWIP) {
            if (this.InputPreview != null) {
                this.InputPreview.Text = "";
                this.InputPreview.Visible = false;
            }
            this.CharInputWIP = false;
            if (moveCur) {
                this.setCursorPos(this.CursorPos + 1, false);
            }
        }
    }

    private void finishKanjiInputSelectionSubmode(boolean moveCur) {
        this.KanjiSelectionWIP = false;
        if (this.InputPreview != null) {
            this.InputPreview.Visible = false;
        }
        if (moveCur) {
            this.setCursorPos(this.CursorPosKanji + 1, false);
        }
        this.CursorPosKanji = this.CursorPos;
    }

    public void run() {
        long time_now;
        int elapsed;
        if (!this.Visible | this.Parent.CurrentFormID != this.FormID) {
            return;
        }
        if (this.CharInputWIP & !this.KanjiSelectionWIP && (elapsed = (int)((time_now = System.currentTimeMillis()) - this.CharInputTime)) > 1000) {
            this.finishCharInput(true);
        }
    }

    public void paint(Graphics g) {
        long time;
        if (!this.Visible | this.Parent.CurrentFormID != this.FormID) {
            return;
        }
        int fore = this.Color;
        int back = this.BackColor;
        if (this.Parent.FocusedControl == this) {
            if (this.Parent.FocusLocked) {
                fore = this.Parent.LockedColor;
                back = this.Parent.LockedBackColor;
                if (this.InputMode == 3) {
                    back = -16744448;
                }
            } else {
                fore = this.Parent.SelectionColor;
                back = this.Parent.SelectionBackColor;
            }
        }
        boolean drawCursor = false;
        if (this.Parent.FocusedControl == this & this.Parent.FocusLocked && ((time = System.currentTimeMillis()) & 0x100L) != 0L) {
            drawCursor = true;
        }
        int curFrom = this.CursorPos;
        int curTo = this.CursorPos;
        if (this.InputMode == 3) {
            curFrom = this.CursorPosKanji;
        }
        g.setColor(back);
        g.fillRect(this.Left, this.Top, this.Width * this.Parent.CellSize, this.Height * this.Parent.CellSize * 2);
        this.Parent.JPStr.CursorType = 0;
        this.Parent.JPStr.ProcessAlpha = this.AdvDrawing;
        int drawed = this.Parent.JPStr.drawJapStringEx(g, this.Left, this.Top, this.Text, fore, back, fore, this.Width, this.Height, this.TextOffset, false, curFrom, curTo, drawCursor, this.Parent.Zoom);
        this.EOFVisible = drawed == -1;
    }

    private String rightStr(String s, int pos) {
        int len = s.length();
        if (len > pos) {
            return s.substring(pos, len);
        }
        return "";
    }

    private void ModifyCurrentChar(char c) {
        String s = this.Text;
        this.Text = s.substring(0, this.CursorPos) + c + this.rightStr(s, this.CursorPos + 1);
    }

    private void InitKanjiMode() {
        this.KanjiSelectionWIP = false;
        this.CursorPosKanji = this.CursorPos;
    }

    private void InitInputPreview() {
        if (this.InputPreview != null) {
            this.InputPreview.Text = this.CharInputStr;
            this.InputPreview.Visible = true;
            this.InputPreview.setCursorPos(this.CharInputPos);
        }
    }

    private void RotateSelectedChar(int dir) {
        int len = this.CharInputStr.length();
        this.CharInputPos += dir;
        if (this.CharInputPos < 0) {
            this.CharInputPos = len - 1;
        }
        if (this.CharInputPos >= len) {
            this.CharInputPos = 0;
        }
        if (this.InputPreview != null) {
            this.InputPreview.setCursorPos(this.CharInputPos);
        }
        char c = this.GetCurrentInputChar();
        this.ModifyCurrentChar(c);
    }

    public char GetCurrentInputChar() {
        char c = this.CharInputStr.charAt(this.CharInputPos);
        return c;
    }

    private void RemovePreviousChar() {
        int len = this.Text.length();
        if (len > 0 & this.CursorPos > 0 & this.CursorPos <= len) {
            String s = this.Text;
            this.Text = s.substring(0, this.CursorPos - 1) + this.rightStr(s, this.CursorPos);
            this.setCursorPos(this.CursorPos - 1, false);
            if (this.CursorPosKanji > this.CursorPos) {
                this.CursorPosKanji = this.CursorPos;
            }
        }
    }

    private void InitKanjiSelectionMode() {
        String reading = this.Text.substring(this.CursorPosKanji, this.CursorPos);
        String kanjis = this.Parent.JPInput.FindKanjiTableByReading(reading);
        if (kanjis != "") {
            String s = this.Text;
            this.Text = s.substring(0, this.CursorPosKanji) + kanjis.charAt(0) + this.rightStr(s, this.CursorPos);
            this.setCursorPos(this.CursorPosKanji + 1, true);
            if (kanjis.length() > 1) {
                this.KanjiSelectionWIP = true;
                this.CharInputStr = kanjis;
                this.CharInputPos = 0;
                this.setCursorPos(this.CursorPos - 1, true);
                this.InitInputPreview();
            }
        }
    }

    public void changeInputMode(int mode) {
        if (mode < 0) {
            mode = 3;
        }
        if (mode >= 4) {
            mode = 0;
        }
        this.finishCharInput(true);
        this.InputMode = mode;
        if (this.InputMode == 3) {
            this.InitKanjiMode();
        }
    }

    public char getSelectedChar() {
        if (this.CursorPos >= 0 & this.CursorPos < this.Text.length()) {
            return this.Text.charAt(this.CursorPos);
        }
        return '\u0000';
    }

    public void movToMakeCursorVisibleMultiLine() {
        if (this.CursorPos < this.TextOffset) {
            while (this.CursorPos < this.TextOffset && this.TextOffset > 0) {
                this.scrollUp();
            }
            return;
        }
        if (this.CursorPos > this.TextOffset) {
            CursorXY xy = this.getCursorXY();
            if (xy.Y < 0) {
                return;
            }
            for (int distance_y = xy.Y - (this.Height - 1); distance_y > 0; --distance_y) {
                this.scrollDown();
            }
        }
    }

    public void scrollUp() {
        if (this.TextOffset == 0) {
            return;
        }
        --this.TextOffset;
        boolean paragraphEnd = this.Text.charAt(this.TextOffset) == '\n';
        int pw = this.getParagraphWidth(this.TextOffset);
        if (!paragraphEnd) {
            --pw;
        }
        int move = this.charsUntilBOL(this.TextOffset, pw %= this.Width);
        this.TextOffset -= move;
        if (this.TextOffset < 0) {
            this.TextOffset = 0;
        }
    }

    public void scrollDown() {
        int move = this.charsUntilEOL(this.TextOffset, 0);
        this.TextOffset += move + 1;
    }

    public boolean isEOFVisible() {
        return this.EOFVisible;
    }

    public boolean isBOFVisible() {
        return this.TextOffset == 0;
    }

    public void setCursorPos(int pos, boolean kanjiCursor) {
        this.CursorPos = pos;
        if (kanjiCursor) {
            this.CursorPosKanji = this.CursorPos;
        }
        if (this.Height == 1) {
            this.TextOffset = this.Parent.JPStr.movToMakeCursorVisible(this.Text, this.Width, this.TextOffset, this.CursorPos);
        } else {
            this.movToMakeCursorVisibleMultiLine();
        }
    }

    public CursorXY getCursorXY() {
        CursorXY xy = new CursorXY(-1, -1);
        if (this.TextOffset > this.CursorPos) {
            return xy;
        }
        xy.X = 0;
        xy.Y = 0;
        for (int i = this.TextOffset; i < this.CursorPos; ++i) {
            char c = this.Text.charAt(i);
            if (c < '\u3000') {
                if (c != '\n') {
                    if (xy.X + 1 >= this.Width) {
                        ++xy.Y;
                        xy.X = 0;
                        continue;
                    }
                    ++xy.X;
                    continue;
                }
                ++xy.Y;
                xy.X = 0;
                continue;
            }
            if (xy.X + 2 >= this.Width) {
                ++xy.Y;
                xy.X = 0;
                continue;
            }
            xy.X += 2;
        }
        return xy;
    }

    public int charsUntilEOL(int pos, int currentXpos) {
        int widthRemain = this.Width - currentXpos;
        int len = this.Text.length() - 1;
        int res = 0;
        while (pos < len && widthRemain > 0) {
            char c = this.Text.charAt(pos);
            if (c < '\u3000') {
                if (c == '\n' || --widthRemain <= 0) break;
                ++res;
            } else {
                if ((widthRemain -= 2) <= 0) break;
                ++res;
            }
            if (widthRemain <= 0) break;
            ++pos;
        }
        return res;
    }

    public int charsUntilBOL(int pos, int currentXpos) {
        int widthRemain = currentXpos;
        int res = 0;
        if (this.Text.charAt(pos) == '\n') {
            --pos;
        }
        while (pos >= 0 && widthRemain > 0) {
            char c = this.Text.charAt(pos);
            if (c < '\u3000') {
                if (c == '\n') break;
                --widthRemain;
                ++res;
            } else {
                widthRemain -= 2;
                ++res;
            }
            if (widthRemain <= 0) break;
            --pos;
        }
        return res;
    }

    public int findXPos(int offset, int xpos) {
        int len = this.Text.length();
        int mov = 0;
        while (offset + mov < len & xpos > 0) {
            char c = this.Text.charAt(offset + mov);
            if (c < '\u3000') {
                if (c == '\n') break;
                --xpos;
                ++mov;
                continue;
            }
            if ((xpos -= 2) < 0) break;
            ++mov;
        }
        return mov;
    }

    private int getParagraphWidth(int paragraphEndPos) {
        int w = 0;
        int pos = paragraphEndPos;
        char c = this.Text.charAt(pos);
        if (c == '\n' && pos > 0) {
            --pos;
        }
        do {
            if ((c = this.Text.charAt(pos)) < '\u3000') {
                if (c == '\n') continue;
                ++w;
                continue;
            }
            w += 2;
        } while (--pos >= 0 && c != '\n');
        return w;
    }

    public void moveCursorUp() {
        if (this.Width == 1) {
            return;
        }
        if (this.CursorPos >= this.Text.length()) {
            this.CursorPos = this.Text.length() - 1;
        }
        CursorXY xy = this.getCursorXY();
        int mov = this.charsUntilBOL(this.CursorPos, xy.X);
        if (this.CursorPos - (mov + 1) < 0) {
            this.setCursorPos(0, true);
            return;
        }
        if (this.Text.charAt(this.CursorPos - ++mov) == '\n') {
            int pw = this.getParagraphWidth(this.CursorPos - mov);
            mov += this.charsUntilBOL(this.CursorPos - mov, pw %= this.Width);
        } else {
            mov += this.charsUntilBOL(this.CursorPos - mov, this.Width - 1);
        }
        if (this.CursorPos - mov < 0) {
            mov = this.CursorPos;
        }
        int more = this.findXPos(this.CursorPos - mov, xy.X);
        this.setCursorPos(this.CursorPos - mov + more, true);
    }

    public void moveCursorDown() {
        int len;
        if (this.Width == 1) {
            return;
        }
        CursorXY xy = this.getCursorXY();
        int mov = this.charsUntilEOL(this.CursorPos, xy.X);
        if (this.CursorPos + mov + 1 < (len = this.Text.length())) {
            ++mov;
        }
        int more = this.findXPos(this.CursorPos + mov, xy.X);
        this.setCursorPos(this.CursorPos + mov + more, true);
    }

    public boolean keyPressed(int keyCode) {
        boolean pressed = true;
        if (!this.Visible | this.Parent.CurrentFormID != this.FormID) {
            return pressed;
        }
        int len = this.Text.length();
        switch (keyCode) {
            case 1000: {
                if (this.InputMode == 3) {
                    if (!this.KanjiSelectionWIP) {
                        this.finishCharInput(true);
                        this.InitKanjiSelectionMode();
                        return pressed;
                    }
                    this.finishKanjiInputSelectionSubmode(true);
                    this.RemovePreviousChar();
                    this.CursorPosKanji = this.CursorPos;
                    break;
                }
                this.finishCharInput(true);
                this.moveCursorUp();
                break;
            }
            case 1001: {
                if (this.InputMode == 3 & this.KanjiSelectionWIP) {
                    this.finishKanjiInputSelectionSubmode(true);
                    pressed = false;
                    break;
                }
                this.finishCharInput(true);
                this.moveCursorDown();
                break;
            }
            case 1002: {
                if (this.InputMode == 3 && this.KanjiSelectionWIP) {
                    this.RotateSelectedChar(-1);
                    return pressed;
                }
                if (this.CursorPos > 0) {
                    this.setCursorPos(this.CursorPos - 1, true);
                }
                this.finishCharInput(false);
                break;
            }
            case 1003: {
                if (this.InputMode == 3 && this.KanjiSelectionWIP) {
                    this.RotateSelectedChar(1);
                    return pressed;
                }
                if (this.CursorPos < this.Text.length()) {
                    this.setCursorPos(this.CursorPos + 1, true);
                }
                this.finishCharInput(false);
                break;
            }
            case 1004: {
                this.finishCharInput(true);
                break;
            }
            case 1006: 
            case 1007: {
                this.finishCharInput(true);
                this.RemovePreviousChar();
                break;
            }
            case 35: {
                if (this.InputMode == 3 & this.KanjiSelectionWIP) {
                    return pressed;
                }
                if (!this.CharInputWIP) break;
                char c = '\u0000';
                if (this.CursorPos < this.Text.length()) {
                    c = this.Text.charAt(this.CursorPos);
                    c = this.Parent.JPInput.RotateKana(c);
                }
                if (c == '\u0000') break;
                this.CharInputTime = System.currentTimeMillis();
                this.ModifyCurrentChar(c);
                break;
            }
            default: {
                if (keyCode <= 0 | keyCode >= 128) {
                    return pressed;
                }
                if (this.InputMode == 3 & this.KanjiSelectionWIP) {
                    return pressed;
                }
                if (this.CharInputWIP & keyCode != this.CharInputKeyCode) {
                    this.finishCharInput(true);
                }
                boolean addChr = false;
                if (!this.CharInputWIP) {
                    this.CharInputTime = System.currentTimeMillis();
                    int keyInput = keyCode;
                    int charStrOffset = this.InputMode;
                    if (this.InputMode == 3) {
                        charStrOffset = 2;
                    }
                    switch (charStrOffset) {
                        case 0: {
                            this.CharInputStr = this.Parent.JPInput.CharInputA[keyCode];
                            break;
                        }
                        case 1: {
                            this.CharInputStr = this.Parent.JPInput.CharInputK[keyCode];
                            break;
                        }
                        default: {
                            this.CharInputStr = this.Parent.JPInput.CharInputH[keyCode];
                        }
                    }
                    if (this.CharInputStr == null) {
                        return pressed;
                    }
                    if (this.CharInputStr.length() == 0) {
                        return pressed;
                    }
                    this.CharInputPos = 0;
                    this.InitInputPreview();
                    this.CharInputWIP = true;
                    this.CharInputKeyCode = keyCode;
                    addChr = true;
                } else {
                    this.CharInputTime = System.currentTimeMillis();
                    this.RotateSelectedChar(1);
                }
                char c = this.CharInputStr.charAt(this.CharInputPos);
                String s = this.Text;
                if (addChr) {
                    this.Text = s.substring(0, this.CursorPos) + c + this.rightStr(s, this.CursorPos);
                    break;
                }
                this.ModifyCurrentChar(c);
            }
        }
        return pressed;
    }

    class CursorXY {
        public int X;
        public int Y;

        public CursorXY(int x, int y) {
            this.X = x;
            this.Y = y;
        }
    }
}

